<?php
namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * VM\ApiBundle\Entity\SummaryCompanyRound
 *
 * @ORM\Table(name="summary_company_round")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Entity\SummaryCompanyRoundRepository")
 * @ExclusionPolicy("all")
 */
class SummaryCompanyRound
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="round_id", type="integer")
     */
    private $roundId;

    /**
     * @var integer
     *
     * @ORM\Column(name="company_id", type="integer")
     */
    private $companyId;

    /**
     * @var text
     *
     * @ORM\Column(name="data", type="text")
     */
    private $data;

    /**
     * @var text
     *
     * @ORM\Column(name="results", type="text")
     */
    private $results;

    /**
     * @var integer
     *
     * @ORM\Column(name="zapasy", type="integer")
     */
    private $zapasy;

    /**
     * @ORM\ManyToOne(targetEntity="Round",inversedBy="summaryCompanyRound")
     * @ORM\JoinColumn(name="round_id", referencedColumnName="id")
     */
    protected $round;

    /**
     * @ORM\ManyToOne(targetEntity="Company",inversedBy="summaryCompanyRound")
     * @ORM\JoinColumn(name="company_id", referencedColumnName="id")
     */
    protected $company;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set roundId
     *
     * @param integer $roundId
     * @return SummaryCompanyRound
     */
    public function setRoundId($roundId)
    {
        $this->roundId = $roundId;
    
        return $this;
    }

    /**
     * Get roundId
     *
     * @return integer 
     */
    public function getRoundId()
    {
        return $this->roundId;
    }

    /**
     * Set companyId
     *
     * @param integer $companyId
     * @return SummaryCompanyRound
     */
    public function setCompanyId($companyId)
    {
        $this->companyId = $companyId;
    
        return $this;
    }

    /**
     * Get companyId
     *
     * @return integer 
     */
    public function getCompanyId()
    {
        return $this->companyId;
    }

    /**
     * Set data
     *
     * @param string $data
     * @return SummaryCompanyRound
     */
    public function setData($data)
    {
        $this->data = $data;
    
        return $this;
    }

    /**
     * Get data
     *
     * @return string 
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * Set round
     *
     * @param \VM\ApiBundle\Entity\Round $round
     * @return SummaryCompanyRound
     */
    public function setRound(\VM\ApiBundle\Entity\Round $round = null)
    {
        $this->round = $round;
    
        return $this;
    }

    /**
     * Get round
     *
     * @return \VM\ApiBundle\Entity\Round 
     */
    public function getRound()
    {
        return $this->round;
    }

    /**
     * Set company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return SummaryCompanyRound
     */
    public function setCompany(\VM\ApiBundle\Entity\Company $company = null)
    {
        $this->company = $company;
    
        return $this;
    }

    /**
     * Get company
     *
     * @return \VM\ApiBundle\Entity\Company 
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Set results
     *
     * @param string $results
     * @return SummaryCompanyRound
     */
    public function setResults($results)
    {
        $this->results = $results;
    
        return $this;
    }

    /**
     * Get results
     *
     * @return string 
     */
    public function getResults()
    {
        return $this->results;
    }

    /**
     * Set zapasy
     *
     * @param integer $zapasy
     * @return SummaryCompanyRound
     */
    public function setZapasy($zapasy)
    {
        $this->zapasy = $zapasy;
    
        return $this;
    }

    /**
     * Get zapasy
     *
     * @return integer 
     */
    public function getZapasy()
    {
        return $this->zapasy;
    }
}